//---------------------------------------------------------------
// Fichero:  ilustracion.asy
// Objetivo: Mostrar la ilustración
// Fecha:    V.5.5.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// El vértice de arriba
pair A=(0,9.484);

// El vértice de la izquierda
pair B=(-8.891,0);

// El vértice de la derecha
pair C=(14.109,0);

// La proyección de A sobre BC
pair D=(0,0);

// La separación entre las flechas y el objeto
real Separacion = 1;

// Las flechas que marcan los segmentos
pen FormatoFlecha=mediumblue+0.75bp;
draw(B+Separacion*(0,-1) -- D+Separacion*(0,-1), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(C+Separacion*(0,-1) -- D+Separacion*(0,-1), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));
draw(C+Separacion*(0,-3.5) -- B+Separacion*(0,-3.5), FormatoFlecha,
     Arrows(HookHead,3bp), Bars(1.5mm));

// Los textos
pen FormatoTexto=fontsize(10pt)+Helvetica(series="b",shape="n");
label("A", A, N, black+FormatoTexto);
label("B", B, W, black+FormatoTexto);
label("C", C, E, black+FormatoTexto);
label("D", D, NE, black+FormatoTexto);
label("13", (A+B)/2+Separacion*(-1,1), deepgreen+FormatoTexto);
label("17", (A+C)/2+Separacion*(1,1), deepgreen+FormatoTexto);
label("x", (B+D)/2+Separacion*(0,-2.2), red+FormatoTexto);
label("23-x", (C+D)/2+Separacion*(0,-2), red+FormatoTexto);
label("h", (A+D)/2+Separacion*(-1,-0.2), red+FormatoTexto);
label("23", (C+B)/2+Separacion*(0,-4.5), deepgreen+FormatoTexto);

// Dibujamos el triángulo
draw(A--B--C--A);

// La altura
draw(A -- D, gray);
markrightangle(A, D, B, 2mm, 0.5bp+black);

// Marcamos los puntos importantes
pen FormatoPunto=3bp+black;
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(D,FormatoPunto);
