//---------------------------------------------------------------
// Fichero:  figura.asy
// Objetivo: Representar la figura
// Fecha:    D.14.5.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// La circunferencia grande
fill(circle((0,0),1), gray);

// Quitamos dos cuartos de circunferencia
fill(buildcycle(arc((1,1), (0,1), (1,0)), ((1,0) -- (1,1) -- (0,1))),
     white);
fill(buildcycle(arc((-1,-1), (0,-1), (-1,0)), ((-1,0) -- (-1,-1) -- (0,-1))),
     white);

// El cuadrado
draw(box((-1,-1),(1,1)));

// Separación entre figuras
real Separacion = 0.1;

// Las flechas
draw((-1,-1-Separacion) -- (0,-1-Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));
draw((0,-1-Separacion) -- (1,-1-Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));
draw((1+Separacion,-1) -- (1+Separacion,0),
     blue, Arrows(HookHead,5bp), Bars(2mm));
draw((1+Separacion,0) -- (1+Separacion,1),
     blue, Arrows(HookHead,5bp), Bars(2mm));
draw((-1,1+Separacion) -- (1,1+Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));
draw((-1-Separacion,-1) -- (-1-1Separacion,1),
     blue, Arrows(HookHead,5bp), Bars(2mm));

// Los textos
label("$\frac{a}{2}$", (-0.5,-1-3*Separacion));
label("$\frac{a}{2}$", (0.5,-1-3*Separacion));
label("$\frac{a}{2}$", (1+2*Separacion, -0.5));
label("$\frac{a}{2}$", (1+2*Separacion, 0.5));
label("$a$", (-1-2*Separacion, 0));
label("$a$", (0, 1+2*Separacion));
