//---------------------------------------------------------------
// Fichero:  hexagono.asy
// Objetivo: Dibujar un hexágono rodeado de sectores circulares
// Fecha:    J.11.5.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// El hexágono
path Hexagono=polygon(6);

// La construcción
int Ini=-180, Fin=60;
for ( int i=0 ; i<6 ; ++i )
    {
    if ( i%2>0 )
        { draw(arc(point(Hexagono,i),0.5,Ini+60,Fin-60,CW)); }
    else
        { draw(arc(point(Hexagono,i),0.5,Ini,Fin)); }
    Ini+=240;
    Fin+=240;
    }
draw(Hexagono,gray);
