//---------------------------------------------------------------
// Fichero:  diagrama.asy
// Objetivo: Dibujar el diagrama de caja y bigotes
// Fecha:    D.10.12.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// fontsize()
import fontsize;

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(1);

// Los valores estadísticos
real Md=33, Q1=16, Q3=45, Mn=9, LS=88.5;

// Los valores visuales
real Ancho=10, Sep=0.5;

// La caja
draw(box((Q1,0),(Q3,Ancho)));

// La mediana
draw((Md,0)--(Md,Ancho));

// Bigote izquierdo
draw((Mn,Ancho/2)--(Q1,Ancho/2));
draw((Mn,Ancho/2+Sep)--(Mn,Ancho/2-Sep));

// Bigote derecho
draw((Q3,Ancho/2)--(LS,Ancho/2));
draw((LS,Ancho/2+Sep)--(LS,Ancho/2-Sep));

// El valor atípico
path Hex=shift(0,Ancho/2)*scale(0.5)*polygon(6);
filldraw(shift(91,0)*Hex);

// La escala
draw((8,-2) -- (92,-2), blue);
pen Formato=fontsize(10pt)+blue;
for ( int i=10 ; i<95 ; i+=5 )
    {
    draw((i,-2+Sep) -- (i,-2-Sep), blue);
    label(string(i),(i,-2-Sep),S,Formato);
    }
