#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  prepara.py
# Objetivo: Prepara un ejemplo de datos
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    D.12.11.2023
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

from numpy import random

#------------------------------------------------
# Constantes
#------------------------------------------------

# El número de datos
Num = 20

# La media
Media = 6.2

# La desviación típica
Desviacion = 2.5

# Los valores mínimo y máximo
Menor = 1.3
Mayor = 9.8

#------------------------------------------------
# El programa
#------------------------------------------------

# La lista de datos elegidos
Lista = []

# Queremos obtener Num datos
while len(Lista)<Num:

    # Obtenemos un valor aleatorio según una normal
    Valor = random.normal(loc=Media, scale=Desviacion)

    # Vemos si está más cerca de tres sigmas
    if Valor>Menor and Valor<Mayor:
        # Lo redondeamos a un decimal
        Valor = round(Valor,1)
        # Lo imprimimos
        Cadena = str(Valor)
        print Cadena.replace(".", ","),
        # Lo guardamos
        Lista.append(Valor)

# Separador
print '\nOrdenados:'

# Ordenamos los datos de menor a mayor y los imprimimos:
Lista.sort()
for i in range(Num):
    print Lista[i],
