//---------------------------------------------------------------
// Fichero:  100m.asy
// Objetivo: Dibujar el diagrama de caja y bigotes de 100 m
// Fecha:    M.12.12.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// fontsize()
import fontsize;

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(1);

// Los valores estadísticos
real Md=9.94, Q1=9.9, Q3=9.99, LI=9.765, LS=10.03;

// Los valores visuales
real Ancho=0.05, Sep=0.01;

// La caja
draw(box((Q1,0),(Q3,Ancho)));

// La mediana
draw((Md,0)--(Md,Ancho));

// Bigote izquierdo
draw((LI,Ancho/2)--(Q1,Ancho/2));
draw((LI,Ancho/2+Sep)--(LI,Ancho/2-Sep));

// Bigote derecho
draw((Q3,Ancho/2)--(LS,Ancho/2));
draw((LS,Ancho/2+Sep)--(LS,Ancho/2-Sep));

// Valores atípicos
path Hex=shift(0,Ancho/2)*scale(0.005)*polygon(6);
filldraw(shift(9.69,0)*Hex);

// La escala
real Ord=-0.025;
draw((9.6,Ord) -- (10.1,Ord), blue);
pen Formato=fontsize(14pt)+blue;
for ( int i=96 ; i<102 ; i+=1 )
    {
    draw((i/10,Ord+Sep/2) -- (i/10,Ord-Sep/2), blue);
    label(replace(string(i/10),'.',','),(i/10,Ord-Sep),S,Formato);
    }
