//---------------------------------------------------------------
// Fichero:  resolucion3.asy
// Objetivo: Representar la resolución 3
// Fecha:    J.9.11.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm,4.8cm);

// Grosor de las líneas
defaultpen(1);

// El formato de texto
pen Formato=black+fontsize(6pt);

// Los valores de los extremos de los intervalos
string Valor[]={'40', '45', '50', '55', '60', '65', '70', '75'};
int TotalVal = Valor.length;

// Las frecuencias
int Frecuencia[]={3, 8, 20, 23, 25, 17, 9};
int MaxFre=max(Frecuencia);

// Escala para modificar las frecuencias
real Escala=0.25;

// Los ejes
draw((0,0)--(TotalVal+.5,0));
draw((0,0)--(0,Escala*(MaxFre+.5)));

// El eje de ordenadas
for ( int i=1 ; i<=MaxFre ; ++i )
    {
    label(string(i), (0,Escala*i), 2*W, Formato);
    draw((-0.1,Escala*i)--(0.1,Escala*i));
    }

// El eje de absisas
for ( int i=0 ; i<TotalVal ; ++i )
    {
    label(Valor[i], (i+1,0), 1.5*S, Formato);
    draw((i+1,-0.05)--(i+1,0.05));
    }

// La marca de que cortamos un trozo de eje de abscisas
fill(box((0.4,-0.1),(0.6,0.1)),white);
draw((0.35,-0.1)--(0.45,0.1));
draw((0.55,-0.1)--(0.65,0.1));

// Las barras
for ( int i=1 ; i<TotalVal ; ++i )
    { filldraw(box((i,0),(i+1,Escala*Frecuencia[i-1])),lightgray); }
