//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Mostrar una sucesión de rectángulos
// Fecha:    V.2.9.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Para fontsize()
import fontsize;

// Tamaño de la imagen
size(0cm,3cm);

// Grosor de las líneas
defaultpen(1);

// Primer rectángulo
pair A=(0,0), B=(1,1);
draw(box(A,B));
label("$1$",(A+B)/2,fontsize(10pt)+blue);

// Segundo rectángulo
pair A=(1,0), B=(2,0.5);
draw(box(A,B));
label("$\frac{1}{2}$",(A+B)/2,fontsize(10pt)+blue);

// Tercer rectángulo
pair A=(1,0.5), B=(1.5,1);
draw(box(A,B));
label("$\frac{1}{4}$",(A+B)/2,fontsize(10pt)+blue);

// Cuarto rectángulo
pair A=(1.5,0.5), B=(2,0.75);
draw(box(A,B));
label("$\frac{1}{8}$",(A+B)/2,fontsize(10pt)+blue);

// Quinto rectángulo
pair A=(1.5,0.75), B=(1.75,1);
draw(box(A,B));
label("$\frac{1}{16}$",(A+B)/2,fontsize(10pt)+blue);

// Sexto rectángulo
pair A=(1.75,0.75), B=(2,0.875);
draw(box(A,B));
label("$\frac{1}{32}$",(A+B)/2,fontsize(6pt)+blue);

// Séptimo rectángulo
pair A=(1.75,0.875), B=(1.875,1);
draw(box(A,B));
label("$\frac{1}{64}$",(A+B)/2,fontsize(6pt)+blue);

// Octavo rectángulo
pair A=(1.875,0.875), B=(2,0.9375);
draw(box(A,B));

// Noveno rectángulo
pair A=(1.875,0.9375), B=(1.9375,1);
draw(box(A,B));
