//---------------------------------------------------------------
// Fichero:  ejemplo6.asy
// Objetivo: Mostrar el ejemplo 6
// Fecha:    L.13.3.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Dimensiones de los ejes
real Xmin = -7, Xmax = 7, Ymin = -7, Ymax = 7, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(4pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
draw((-7,5.8333)--(7,-5.8333));

// La ordenada en el origen
pen Negrita=Helvetica(series="b",shape="n");
label("q=0",(0,0),2NE,Negrita+heavygreen+fontsize(8pt));

// El punto de corte con el eje de ordenadas
dot((0,0),3bp+red);
