//---------------------------------------------------------------
// Fichero:  funcionFres.asy
// Objetivo: Representar la solución de una función
// Fecha:    V.10.2.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

// Dimensiones de los ejes
real Xmin = -8, Xmax = 8, Ymin = -2, Ymax = 3, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(6pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
draw((-8,3) -- (-6,2) -- (-4,2) -- (-3,-2) -- (-2,-2) -- (1,1) -- (4,1) --
     (5,0) -- (7,0) -- (8,3));

// Los puntos del eje de abscisas
dot((-5,0),blue+3pt);
dot((-2.5,0),blue+3pt);
dot((1.7,0),blue+3pt);
dot((3.6,0),blue+3pt);
dot((5.5,0),blue+3pt);
dot((6.5,0),blue+3pt);

// Las flechas van a la gráfica
draw((-5,0.2) -- (-5,1.8), deepgreen, Arrow(HookHead,3bp));
draw((-2.5,-0.1) -- (-2.5,-1.8), deepgreen, Arrow(HookHead,3bp));
draw((1.7,0.1) -- (1.7,0.8), deepgreen, Arrow(HookHead,3bp));
draw((3.6,0.1) -- (3.6,0.8), deepgreen, Arrow(HookHead,3bp));

// Los puntos de la gráfica
dot((-5,2),red+3pt);
dot((-2.5,-2),red+3pt);
dot((1.7,1),red+3pt);
dot((3.6,1),red+3pt);

// Las flecha que van hasta el eje de ordenadas
draw((-3.8,2) -- (-0.5,2), deepgreen, Arrow(HookHead,3bp));
draw((-1.8,-2) -- (-0.75,-2), deepgreen, Arrow(HookHead,3bp));
draw((0.8,1) -- (0.2,1), deepgreen, Arrow(HookHead,3bp));
