//---------------------------------------------------------------
// Fichero:  esquinas.asy
// Objetivo: Representar un cuadrado sin esquinas
// Fecha:    D.22.1.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(2.5cm);

// Grosor de las líneas
defaultpen(1);

// Construcción de la figura
pair Vertice;
path Figura;
for (int i=0 ; i<5 ; ++i)
  {
  for (int j=-1 ; j<2 ; j+=2)
    {
    Vertice=dir(90*i+j*30);
    Figura=Figura -- Vertice;
    }
  }

// La figura
draw(Figura);
