//---------------------------------------------------------------
// Fichero:  desarrollo.asy
// Objetivo: Mostrar el desarrollo del problema
// Fecha:    V.21.4.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(18cm);

// Grosor de las líneas
defaultpen(1);

// Los valores de x que queremos representar
real Abs[]={0.2,0.5,1,1.5,2,2.5,3,3.5,3.8};

// La separación
real Separacion=0.5;
real Comienzo=0.5;

// Los rectángulos
pen FormatoEtiqueta=blue+fontsize(10pt)+Bookman(series="m",shape="n");
for ( int i=0 ; i<Abs.length ; ++i )
  {
  real x=Abs[i], y=4-x;
  filldraw(box((Comienzo,0),(Comienzo+x,y)),lightgray);
  label(string(x),(Comienzo+x/2,-0.3),FormatoEtiqueta);
  if (i==4)
      { label("A=4",(Comienzo+x/2,2.3),FormatoEtiqueta); }
  Comienzo = Comienzo+x+Separacion;
  }

// La recta
draw((0,0)--(Comienzo,0));
