#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  prepara.py
# Objetivo: Prepara un ejercicio de factorización por división exacta
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    M.27.9.2022
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
# Ejemplo:  cociente: x²+2x+3; divisor: x+4
#           prepara.py 1 2 3 4
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

#------------------------------------------------
# Constantes
#------------------------------------------------

Exp = u'⁰¹²³⁴⁵⁶⁷⁸⁹'

#------------------------------------------------
# Funciones
#------------------------------------------------

#------------------------------------------------
def Explica(Lista):

    if all(m==0 for m in Lista):
        Respuesta = '0'

    else:
        Respuesta = ''
        for i,m in enumerate(Lista):
            Potencia = len(Lista)-1-i

            if m<>0:
                Signo = ''
                if m<0:
                    Signo = u'−'
                    m = -m
                elif i<>0: Signo = '+'

                Coeficiente = str(m) if m<>1 or Potencia==0 else ''
                Letra = '' if Potencia==0 else 'x'
                Exponente = '' if Potencia<2 else Exp[Potencia]

                Respuesta += Signo + Coeficiente + Letra + Exponente

    return Respuesta

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos los datos de la línea de órdenes
Datos = sys.argv[1:]

# Obtenemos el cociente y el término independiente del divisor
Cociente = map(int,Datos[:-1])
Numero = int(Datos[-1])

# Preparamos el divisor
Divisor = [1, Numero]

# La lista que tendrá el polinomio
Polinomio = [0] * (len(Cociente)+1)

# Obtenemos el polinomio
# Multiplicamos el divisor y el cociente
# (vamos multiplicando monomio a monomio y sumando en el polinomio)
for i,m1 in enumerate(Cociente):
    for j,m2 in enumerate(Divisor):
        Polinomio[i+j] += m1*m2

# Damos el enunciado y la solución
print Explica(Polinomio)
print '(' + Explica(Cociente) + u')·(' + Explica(Divisor) + ')'
