//---------------------------------------------------------------
// Fichero:  cilindro.asy
// Objetivo: Mostrar el cilindro
// Fecha:    M.12.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=10;

// Tamaño de la imagen
size(0,3cm);

// Punto de proyección
currentprojection=orthographic((5,0,2),Z);

// Datos de la figura plana
// He puesto 2.01 para evitar un error
real Radio=2.01, Altura=2;

// La figura plana
path3 Poli=(0,0,0)--(Radio,0,0)--(Radio,0,Altura)--(0,0,Altura);

// El cuerpo de revolución
revolution Cilindro=revolution(Poli,Z);

// Marcamos las bases
skeleton Corte;
Cilindro.transverse(Corte,reltime(Cilindro.g,0.5),P=currentprojection);
draw(shift(Altura/2*Z)*Corte.transverse.front,1bp+black);
draw(shift(-Altura/2*Z)*Corte.transverse.back,1bp+gray+linetype("2 2",8));

// Marcamos el contorno
draw(Cilindro.silhouette(),1bp+black);

// Los tres puntos que marcamos
triple T=(0,0,0), A=(0,Radio,0), B=(0,0,Altura);;
dot(A,blue);
dot(B,blue);
dot(T,blue);

// El radio de la base de abajo
draw(A--T,1bp+blue);
label("2r",(A+T)/2-0.2*Z,blue);

// La altura
draw(T--B,1bp+blue);
label("2r",(T+B)/2-0.25*Y,blue);
