//---------------------------------------------------------------
// Fichero:  diametro.asy
// Objetivo: Mostrar el diámetro de una esfera
// Fecha:    J.31.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// sphere()
import solids;

// Caracteres Unicode
import unicode;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4.8cm);

// Punto de proyección
currentprojection=orthographic((5,0,2),Z);

// Definimos tres puntos
triple T=(0,0,0), A=(0,-1,0), B=(0,1,0);

// La esfera
revolution Esfera=sphere(T,1);

// Dibujamos
skeleton Corte;
Esfera.transverse(Corte,reltime(Esfera.g,0.5),P=currentprojection);
draw(Corte.transverse.back,black+linetype("8 8",8));
draw(Corte.transverse.front,black);
draw(Esfera.silhouette(),black);

// El diámetro
draw(A--B,blue);
label("diámetro",T,S,blue);

// Los puntos
dot(A,blue);
dot(B,blue);
