//---------------------------------------------------------------
// Fichero:  desarrollo.asy
// Objetivo: Mostrar el desarrollo plano de un cono
// Fecha:    J.7.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Datos de la figura plana
real Radio=3.5, Altura=5;

// Cálculo de otros datos
real Generatriz=sqrt(Radio*Radio+Altura*Altura);
real Angulo=degrees(3.14*Radio/Generatriz);

// Formato de texto
pen Formato=blue+fontsize(14pt);

// La base
path Base=circle((-Radio,0),Radio);
draw(Base,1bp+black);
label("Base", (-Radio,0), Formato);

// La superficie lateral
draw(arc((Generatriz,0),Generatriz,-Angulo,Angulo,CW),1bp+black);
draw((Generatriz,0)--Generatriz+Generatriz*dir(Angulo),1bp+black);
draw((Generatriz,0)--Generatriz+Generatriz*dir(-Angulo),1bp+black);
label(rotate(90)*"Superficie lateral", (Generatriz/2,0), Formato);
