//---------------------------------------------------------------
// Fichero:  arealateral.asy
// Objetivo: Mostrar cómo calcular el área lateral de un cono
// Fecha:    V.8.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.4cm);

// Datos de la figura plana
real Radio=3.5, Altura=5;

// Cálculo de otros datos
real Generatriz=sqrt(Radio*Radio+Altura*Altura);
real Angulo=degrees(3.14*Radio/Generatriz);

// Formato de texto
pen Formato=blue+fontsize(12pt);

// La circunferencia completa
draw(circle((0,0),Generatriz),1bp+black);

// El área lateral
draw(arc((0,0),1.15*Generatriz,-Angulo,Angulo,CW),0.75bp+blue,
     Arrows(HookHead,5bp), Bars(1mm));
draw((0,0)--Generatriz*dir(Angulo),1bp+black);
draw((0,0)--Generatriz*dir(-Angulo),1bp+black);
label("$A_L$", (-Generatriz/2,0), Formato);
label("$2 \pi r$", (-Generatriz,0)+3*W, Formato);

// Las generatrices
label("$g$", 0.5*Generatriz*dir(Angulo)+E, Formato);
label("$g$", 0.5*Generatriz*dir(-Angulo)+E, Formato);

// Los puntos
dot((0,0),3bp+blue);
dot(Generatriz*dir(Angulo),3bp+blue);
dot(Generatriz*dir(-Angulo),3bp+blue);
