//---------------------------------------------------------------
// Fichero:  desarrollo.asy
// Objetivo: Mostrar el desarrollo plano de un cilindro
// Fecha:    V.1.4.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Datos de la figura plana
real Radio=4, Altura=5;
real Perimetro=2*3.14*Radio;

// Formato de texto
pen Formato=blue+fontsize(12pt);

// La superficie lateral
path Poli=box((0,0),(Perimetro,Altura));
draw(Poli,1bp+black);
label("Superficie lateral", (Perimetro/2,Altura/2), Formato);

// Las bases
path Base=circle((0,0),Radio);
draw(shift(Radio,-Radio)*Base,1bp+black);
label("Base", (Radio,-Radio), Formato);
draw(shift(Perimetro-Radio,Altura+Radio)*Base,1bp+black);
label("Base", (Perimetro-Radio,Altura+Radio), Formato);
