//---------------------------------------------------------------
// Fichero:  ejemplo2d.asy
// Objetivo: Mostrar el ejemplo 2D
// Fecha:    M.29.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3.8cm);

// Datos de la figura plana
real Radio=4, Altura=5;

// La figura plana
path Poli=(0,0)--(Radio,0)--(1.3*Radio,0.5*Altura)--
          (Radio,Altura)--(0,Altura)--cycle;
draw(Poli,2bp+black);

// El eje
real Extra=.4;
draw((0,-Extra)--(0,Altura+Extra), 2bp+black);

// Los puntos
dot("A", (0,0), W, 4bp+blue);
dot("B", (0,Altura), W, 4bp+blue);
dot("C", (Radio,Altura), NE, 4bp+blue);
dot("D", (1.3*Radio,0.5*Altura), E, 4bp+blue);
dot("E", (Radio,0), SE, 4bp+blue);

// La flecha del giro
path Flecha=(Extra,Altura)..(0,Altura+2*Extra)..(-Extra,Altura);
draw(shift(0,Extra)*Flecha,1bp+blue,ArcArrow(SimpleHead));
