//---------------------------------------------------------------
// Fichero:  pestanas1.asy
// Objetivo: Representar un desarrollo plano del cubo con pestañas
// Fecha:    D.13.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,4.5cm);

// Grosor de las líneas
defaultpen(1);

// El lado del cuadrado
int Lado=1;

// Función que dibuja un cuadrado a partir del punto inferior izquierdo
void Cuadrado(pair V)
    { draw(V--V+(0,Lado)--V+(Lado,Lado)--V+(Lado,0)--cycle); }

// Función que dibuja una pestaña
void Pestana(pair A, pair B, pair Dir)
    {
    pair A2, B2, Vector;
    Vector=B-A;
    A2=A+Lado/4*Dir+Vector/5;
    B2=B+Lado/4*Dir-Vector/5;
    draw(A--A2--B2--B);
    }

// El desarrollo
Cuadrado((2,0));
Cuadrado((0,1));
Cuadrado((1,1));
Cuadrado((1,2));
Cuadrado((2,1));
Cuadrado((3,1));

// Las pestañas
Pestana((1,1),(2,1),S);
Pestana((2,0),(3,0),S);
Pestana((3,1),(4,1),S);
Pestana((3,2),(4,2),N);
Pestana((2,2),(2,3),E);
Pestana((1,2),(1,3),W);
Pestana((0,1),(0,2),W);
