//---------------------------------------------------------------
// Fichero:  prisma2d.asy
// Objetivo: Representar un desarrollo plano del prisma
// Fecha:    D.13.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Un pentágono regular
path Pentagono=polygon(5);

// La altura del prisma
real Altura=1;

// Función que dibuja un rectángulo
void Rectangulo(pair C, pair A, pair B)
    {
    pair Vector=Altura*unit((A-C)+(B-C));
    pair A2=A+Vector;
    pair B2=B+Vector;
    draw(A--A2--B2--B--cycle);
    }

// El pentágono de la izquierda
draw(Pentagono);
Rectangulo((0,0),point(Pentagono,0),point(Pentagono,1));
Rectangulo((0,0),point(Pentagono,2),point(Pentagono,3));
Rectangulo((0,0),point(Pentagono,4),point(Pentagono,3));

// El pentágono de la derecha
pair Vector=(Altura+2*Sin(54))*unit(point(Pentagono,0)+point(Pentagono,1));
Pentagono=shift(Vector)*rotate(36)*Pentagono;
draw(Pentagono);
Rectangulo(Vector,point(Pentagono,1),point(Pentagono,2));
Rectangulo(Vector,point(Pentagono,3),point(Pentagono,4));
