//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Representar el ejemplo 2
// Fecha:    X.4.5.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Caracteres Unicode
import unicode;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(0.6);

// Los valores
string Valor[]={'VOX', 'PP', 'PSOE-M', 'Más Madrid', 'Unidas Podemos'};
int TotalVal = Valor.length;

// Las frecuencias
int Frecuencia[]={13, 65, 24, 24, 10};

// Los colores
string Color[]={'63BE21', '1D84CE', 'EF1C27', '45BB89', '7B4977'};

// La constante de proporcionalidad
real k=180/sum(Frecuencia);

// Los semicírculos
real Hueco=0.4;
draw(arc((0,0),1,0,180));
draw(arc((0,0),Hueco,0,180));

// Los sectores
real Angulo=0;
for ( int i=0 ; i<TotalVal ; ++i )
    {
    real Avance=k*Frecuencia[i];
    filldraw(Hueco*dir(Angulo)--arc((0,0),1,Angulo,Angulo+Avance)--
         dir(Angulo+Avance)--arc((0,0),Hueco,Angulo+Avance,Angulo)--cycle,
         rgb(Color[i]),black);
    Angulo += Avance;
    }

// La leyenda
for ( int i=0 ; i<TotalVal ; ++i )
    {
    filldraw(box((1.4,i/5),(1.55,i/5+0.15)),rgb(Color[i]),black);
    label(Valor[i],(1.6,i/5),NE,fontsize(14pt));
    }
