//---------------------------------------------------------------
// Fichero:  barras.asy
// Objetivo: Representar el diagrama de barras
// Fecha:    D.1.5.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,4.5cm);

// Grosor de las líneas
defaultpen(1);

// El formato de texto
pen Formato=black+fontsize(8pt);

// Los valores
string Valor[]={'0', '1', '2', '3', '4', '5', '6', '7', '8'};
int TotalVal = Valor.length;

// Las frecuencias
int Frecuencia[]={2, 7, 4, 9, 8, 4, 10, 6, 7};
int MaxFre=max(Frecuencia);

// Grosor de las barras
real Grosor=0.7;

// Escala para modificar las frecuencias
real Escala=0.75;

// Los ejes
draw((0,0)--(TotalVal+.5,0));
draw((0,0)--(0,Escala*(MaxFre+.5)));

// El eje de ordenadas
for ( int i=1 ; i<=MaxFre ; ++i )
    {
    label(string(i), (0,Escala*i), 2*W, Formato);
    draw((-0.1,Escala*i)--(0.1,Escala*i));
    }

// El eje de absisas y las barras
for ( int i=0 ; i<TotalVal ; ++i )
    {
    label(Valor[i], (i+1,0), 1.5*S, Formato);
    draw((i+1,-0.05)--(i+1,0.05));
    draw(box((i+1-Grosor/2,0),(i+1+Grosor/2,Escala*Frecuencia[i])));
    }
