#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  suma.py
# Objetivo: Da la suma de valores en el sistema sexagesimal
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    D.18.7.2021
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

#------------------------------------------------
# Variables globales
#------------------------------------------------

# Horas, minutos y segundos
h = 0; m = 0; s = 0

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos los sumandos de la línea de órdenes
# Cada sumando tiene el formato h.m.s
for sumando in sys.argv[1:]:
    # Descomponemos el sumando en sus partes
    partes = sumando.split('.')

    # Sumamos horas, minutos y segundos
    h += int(partes[0])
    m += int(partes[1])
    s += int(partes[2])

# Corregimos los segundos
if s>59:
    mt, st = divmod(s,60)
    m += mt
    s = st

# Corregimos los minutos
if m>59:
    ht, mt = divmod(m,60)
    h += ht
    m = mt

# Imprimimos el resultado
print str(h) + '.' + str(m) + '.' + str(s)
