//---------------------------------------------------------------
// Fichero:  enunciado15.asy
// Objetivo: Representar el enunciado 15
// Fecha:    S.24.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve una etiqueta a partir de una cadena
Label Eti(string Texto)
    { return Label(Texto,fontsize(8pt)+blue); }

// Función que devuelve como cadena el valor en
// grados, minutos y segundos (redondeados) de un ángulo en grados
string GMS(real Ang)
    {
    int Gra = Floor(Ang);
    Ang = 60*(Ang - Gra);
    int Min = Floor(Ang);
    int Seg = round(60*(Ang - Min));
    string Respuesta = string(Gra)+"$^\circ$\,";
    Respuesta += string(Min)+"$^\prime$\,";
    Respuesta += string(Seg)+"$^{\prime\prime}$";
    return Respuesta;
    }

// Función que devuelve como etiqueta el valor de un ángulo
Label Ang(pair P1, pair V, pair P2, int e)
    { return Eti(GMS(degrees(P2-V)-degrees(P1-V)+360*e)); }

// Definición de los vértices
real Incognita = 122.09054;
pair A=(0,0), B=(Cos(90-Incognita/2),Sin(90-Incognita/2)), E=(-B.x,B.y),
     C=B+0.5*(rotate(-Incognita,B)*A-B), D=(-C.x,C.y);

// Los ángulos
markangle(Ang(D,C,B,0), radius=4mm, D, C, B, 0.5bp+blue);
markangle(Ang(E,D,C,1), radius=4mm, E, D, C, 0.5bp+blue);
markangle("$\alpha$", radius=4mm, B, A, E, 0.5bp+blue);
markangle("$\alpha$", radius=3mm, C, B, A, 0.5bp+blue);
markangle("$\alpha$", radius=3mm, A, E, D, 0.5bp+blue);

// El pentágono
draw(A -- B -- C -- D -- E -- cycle);
