//---------------------------------------------------------------
// Fichero:  cuadrado.asy
// Objetivo: Representar cómo rellenar un cuadrado
// Fecha:    X.6.10.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Número de subdivisiones
int NumSub = 5;

// Desplazamiento para colocar la rejilla
real Desplazamiento = -NumSub/2;

// El mínimo valor de cada lado
int Min = -floor(NumSub/2);

// Rejilla de ayuda
add(shift(Desplazamiento,Desplazamiento)*grid(NumSub,NumSub,0.5bp+gray));

// Los puntos que hay que ir uniendo
pair[] Camino = {(0,0), (1,0), (1,1), (-1,1), (-1,-1), (2,-1),
                 (2,2), (-2,2), (-2,-2), (2,-2) };

// El trazo que recorre los puntos
for ( int i=0 ; i<Camino.length-1 ; ++i )
    { draw(Camino[i+1] -- Camino[i]); }

// Los puntos centrales de cada cuadrado
for ( int i=0 ; i<NumSub ; ++i )
    {
    for ( int j=0 ; j<NumSub ; ++j )
        { dot((i+Min,j+Min), 5bp+blue); }
    }
