//---------------------------------------------------------------
// Fichero:  general.asy
// Objetivo: Representar la resolución general
// Fecha:    S.11.9.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// El rectángulo que marca la fracción secundaria
fill(box((3,1.8),(7,3)), palered);

// El rectángulo que marca la fracción principal
fill(box((0,0),(3,3)), mediumgray);

// El rectángulo que marca el total
draw(box((0,0),(7,3)));

// La línea vertical
draw((3,0) -- (3,3));

// La línea horizontal
pen Punteado = linetype(new real[] {2,2});
draw((3,1.8) -- (7,1.8), Punteado);

// La separación entre las flechas y el objeto
real Separacion = 0.3;

// Las flechas que marcan las fracciones
draw((7+Separacion,1.8) -- (7+Separacion,3), blue, Bars(1.5mm));
draw((0,-Separacion) -- (3,-Separacion),  blue, Bars(1.5mm));

// Los textos
label("F", (1.5,-3*Separacion), fontsize(13pt));
label("G", (7+3*Separacion,2.3), fontsize(13pt));
label("Q", (5,0.9), fontsize(13pt));
