//---------------------------------------------------------------
// Fichero:  cuadrado2.asy
// Objetivo: Calcular y representar el segundo cuadrado
// Fecha:    D.16.1.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Los coeficientes del polinomio
int Factor[] = {9, 6, 1};

// El grado del polinomio
int G = Factor.length;

// La separación entre dos cuadrados
real Sep=sqrt(2);

// Función que devuelve un punto del plano según los grados
pair Punto(int i, int j)
    {
    real X, Y;
    X=4-(i+j)/2;
    Y=2-(i-j)/2;
    return (Sep*X,Sep*Y);
    }

// Función que devuelve el texto de una potencia dado el grado
string Pot(int g)
    {
    string Respuesta;
    if ( g==0 )  { Respuesta = '1'; }
    if ( g==1 )  { Respuesta = 'x'; }
    if ( g>1 )   { Respuesta = 'x$^'+string(g)+'$'; }
    return (Respuesta);
    }

// Formato de los textos
pen ForGen=Helvetica(series="m",shape="n")+fontsize(3.5mm);
pen ForPot=Helvetica(series="m",shape="n")+fontsize(3.5mm)+blue;
pen ForSol=Helvetica(series="m",shape="n")+fontsize(3mm);

// El cuadrado básico
path Cuadrado = rotate(45)*box((0,0),(1,1));

// La cuadrícula con los productos
for ( int i=0 ; i<G ; ++i )
    {
    for ( int j=0 ; j<G ; ++j )
        {
        pair Pos=Punto(i,j);
        draw(shift(Pos)*Cuadrado,1bp+gray);
        label(string(Factor[i]*Factor[j]),Pos+(0,Sep/2),ForGen);
        }
    }

// Los dos factores
for ( int i=0 ; i<G ; ++i )
    {
    // Las potencias
    pair Pos=Punto(i,G+1);
    draw(shift(Pos)*Cuadrado);
    label(Pot(i),Pos+(0,Sep/2),ForPot);

    pair Pos=Punto(-2,i);
    draw(shift(Pos)*Cuadrado);
    label(Pot(i),Pos+(0,Sep/2),ForPot);

    // Los coeficientes
    pair Pos=Punto(i,G);
    draw(shift(Pos)*Cuadrado);
    label(string(Factor[i]),Pos+(0,Sep/2),ForGen);

    pair Pos=Punto(-1,i);
    draw(shift(Pos)*Cuadrado);
    label(string(Factor[i]),Pos+(0,Sep/2),ForGen);
    }

// El producto de los polinomios
int TamPro = 2*G-1;
int Producto[] = array(TamPro, 0);
for ( int i=0 ; i<G ; ++i )
    {
    for ( int j=0 ; j<G ; ++j )
        { Producto[i+j] += Factor[i]*Factor[j]; }
    }

// La cuadrícula con las sumas
for ( int i=0 ; i<TamPro ; ++i )
    {
    real Anchura = 3*Sep/5;

    // Los coeficientes
    draw(box((2+Anchura*i,1),(2+Anchura*(i+1),0)));
    label(string(Producto[TamPro-i-1]),(2+Anchura*(i+0.5),0.5),ForSol);

    // Las potencias
    draw(box((2+Anchura*i,0),(2+Anchura*(i+1),-1)));
    label(Pot(TamPro-i-1),(2+Anchura*(i+0.5),-0.5),ForPot);

    // Las flechas
    real Altura = 0;
    if ( i!=2 )
        {
        if ( abs(2-i)== 0 )  { Altura = 0; }
        if ( abs(2-i)== 1 )  { Altura = 2; }
        if ( abs(2-i)== 2 )  { Altura = 2.8; }
        draw((2.5+Anchura*i,Altura) -- (2.5+Anchura*i,1.25),
             1pt+heavygreen,Arrow(HookHead,size=1mm));
        }
    }
