#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  producto.py
# Objetivo: Da el producto de dos polinomios
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    V.7.1.2022
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
# Ejemplo:  Para multiplicar (2+7x)(5-3x): ./producto.py 2 7 m 5 -3
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos los datos de la línea de órdenes
Datos = sys.argv[1:]

# Averiguamos dónde está el separador de los dos polinomios
Sep = Datos.index('m')

# Obtenemos los dos polinomios
P1 = map(int,Datos[:Sep])
P2 = map(int,Datos[Sep+1:])

# La lista que tendrá el resultado
Resultado = [0] * (len(sys.argv)-3)

# Vamos multiplicando monomio a monomio y sumando en el resultado
for i,M1 in enumerate(P1):
    for j,M2 in enumerate(P2):
        Resultado[i+j] += M1*M2

# Damos el resultado
for m in Resultado:
  print m,
