//---------------------------------------------------------------
// Fichero:  ladosaltura.asy
// Objetivo: Representar un triángulo con lados y altura
// Fecha:    D.16.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Valores de los lados
int a=36, b=25, c=29;

// Ángulo de rotación de la figura
int Ang=0;

// Función que calcula el vértice según los lados
pair PuntoLados(real a, real b, real c)
  {
  path CirIzq = circle((0,0),b);
  path CirDer = circle((a,0),c);
  pair Cortes[] = intersectionpoints(CirIzq, CirDer);
  return Cortes[0];
  }
    
// Los vértices
pair A=(0,0), B=(a,0), C=PuntoLados(a,b,c);

// El punto proyección
pair Q=(C.x,0);

// Rotamos tres puntos respecto a A
B = rotate(Ang)*B;
C = rotate(Ang)*C;
Q = rotate(Ang)*Q;

// Marcamos el ángulo recto
markrightangle(B, Q, C, 4mm, gray);

// La altura
draw(C -- Q);

// El triangulo
draw(A -- B -- C -- cycle);

// Los datos
label(string(a), (A+B)/2, S);
label(string(b), (A+C)/2, NW);
label(string(c), (B+C)/2, NE);
label("20", (C+Q)/2, SW);
