//---------------------------------------------------------------
// Fichero:  nombres.asy
// Objetivo: Poner nombres a los lados de un triángulo rectángulo
// Fecha:    S.8.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=rotate(10)*(5,0), C=rotate(10)*(0,3);

// El ángulo
markrightangle(B, A, C, 6mm, 0.5bp+gray);

// El triangulo
draw(A -- B -- C -- cycle);

// Los nombres
label(rotate(-20)*"Hipotenusa", (B+C)/2, rotate(-20)*N);
label(rotate(10)*"Cateto", (A+B)/2, rotate(-10)*S);
label(rotate(100)*"Cateto", (A+C)/2, rotate(10)*W);
