//---------------------------------------------------------------
// Fichero:  altura3.asy
// Objetivo: Representar la altura 3
// Fecha:    S.1.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(1,2), B=(0,0), C=(3,0);

// El punto proyección
pair Q=intersectionpoint(A -- B, C -- C+(-4,2));

// Marcamos el ángulo recto
markrightangle(C, Q, B, 4mm, gray);

// La altura
draw(C -- Q, 2bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);

// Los puntos
dot(A, 3bp+black);
dot(B, 3bp+black);
dot(C, 3bp+black);
dot(Q, 3bp+black);
