//---------------------------------------------------------------
// Fichero:  enunciado4.asy
// Objetivo: Representar el enunciado 4
// Fecha:    X.19.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,24), B=(-70,0), C=(7,0);

// El punto proyección
pair Q=(0,0);

// Marcamos el ángulo recto
markrightangle(B, Q, A, 3mm, gray);

// La altura
pen Punteado = linetype(new real[] {2,2});
draw(A -- Q, Punteado);

// El triangulo
draw(A -- B -- C -- cycle);

// Los puntos
dot("A", A, N, 3bp+black);
dot("B", B, SW, 3bp+black);
dot("C", C, SE, 3bp+black);
dot("Q", Q, S, 3bp+black);
