//---------------------------------------------------------------
// Fichero:  enunciado10.asy
// Objetivo: Representar el enunciado 10
// Fecha:    X.19.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,0), B=(45,-28), C=(45,28);

// Los puntos medios
pair M=(B+C)/2;
pair N=(A+C)/2;

// El baricentro
pair G=(A+B+C)/3;

// Las medianas
draw(A -- M);
draw(B -- N);

// El triangulo
draw(A -- B -- C -- cycle);

// Los puntos
dot("A", A, W, 3bp+black);
dot("B", B, SE, 3bp+black);
dot("C", C, NE, 3bp+black);
dot("M", M, E, 3bp+black);
dot("N", N, NW, 3bp+black);
dot("G", G, NNE, 3bp+black);
