//---------------------------------------------------------------
// Fichero:  enunciado08.asy
// Objetivo: Representar el enunciado 8
// Fecha:    V.30.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle() markrightangle()
import geometry;

// Para StickIntervalMarker()
import markers;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(0,5), C=(5,0);

// Los ángulos
markangle("$\alpha$", radius=8mm, A, B, C, 0.5bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);

// El ángulo recto
markrightangle(B, A, C, 4mm, gray);

// Las marcas
marker Formato = StickIntervalMarker(i=1, n=3, angle=45, size=3mm,
                                    space=1mm, p=blue);
draw(A -- C, Formato);
draw(B -- A, Formato);
