//---------------------------------------------------------------
// Fichero:  enunciado13.asy
// Objetivo: Representar el enunciado 13
// Fecha:    X.19.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Valores de los lados
int a=400, b=325, c=85;

// Ángulo de rotación de la figura
int Ang=205;

// Función que calcula el vértice según los lados
pair PuntoLados(real a, real b, real c)
  {
  path CirIzq = circle((0,0),b);
  path CirDer = circle((a,0),c);
  pair Cortes[] = intersectionpoints(CirIzq, CirDer);
  return Cortes[0];
  }

// Los vértices
pair A=(0,0), B=(a,0), C=PuntoLados(a,b,c);

// El punto proyección
pair Q=(C.x,0);

// Rotamos tres puntos respecto a A
B = rotate(Ang)*B;
C = rotate(Ang)*C;
Q = rotate(Ang)*Q;

// Marcamos el ángulo recto
markrightangle(B, Q, C, 2mm, gray);

// La altura
pen Punteado = linetype(new real[] {2,2});
draw(C -- Q, Punteado);

// El triangulo
draw(A -- B -- C -- cycle);

// Los datos
label(string(a), (A+B)/2, 3*SE);
label(string(b), (A+C)/2, 3*NW);
label(string(c), (B+C)/2, S);
label(Label("36",fontsize(8pt)), (C+Q)/2, NE);
