//---------------------------------------------------------------
// Fichero:  enunciado04.asy
// Objetivo: Representar el enunciado 4
// Fecha:    D.9.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(3,0), C=(3,2);

// El ángulo recto
markrightangle(A, B, C, 4mm, 0.5bp+gray);

// El triangulo
draw(A -- B -- C -- cycle);

// Los nombres
label("33", (B+C)/2, E);
label("$x$", (A+B)/2, S);
label("65", (A+C)/2, NW);
