//---------------------------------------------------------------
// Fichero:  solucion4.asy
// Objetivo: Representar la solución 4
// Fecha:    X.5.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 19, Ymin = 0, Ymax = 15, Extra = 0.25;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),1bp+gray));

// Grosor de las líneas
defaultpen(1);

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(8pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Definición de los vértices
pair A=(2,0), B=(0,14), C=(18,8);

// Los puntos medios
pair MAB=(A+B)/2;
pair MAC=(A+C)/2;
pair MBC=(B+C)/2;

// El triangulo
draw(A -- B -- C -- cycle);

// Función que devuelve un vector perpendicular al segmento dado
pair Perpendicular(pair A, pair B)
    { return (A.y - B.y, B.x - A.x); }

// Las mediatrices
pair U1=MAB+0.1*Perpendicular(A,B);
pair U2=MAB-0.8*Perpendicular(A,B);
draw(U1 -- U2, 1bp+deepgreen);
pair V1=MAC+0.4*Perpendicular(A,C);
pair V2=MAC-0.2*Perpendicular(A,C);
draw(V1 -- V2, 1bp+deepgreen);
pair W1=MBC+0.2*Perpendicular(B,C);
pair W2=MBC-0.3*Perpendicular(B,C);
draw(W1 -- W2, 1bp+deepgreen);

// El circuncentro
pair T=intersectionpoint(U1 -- U2, V1 -- V2);
dot(T, 4bp+deepgreen);

