//---------------------------------------------------------------
// Fichero:  solucion2.asy
// Objetivo: Representar la solución 2
// Fecha:    X.5.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=rotate(10)*(2,1), C=rotate(10)*(-2,1);

// Función que devuelve un vector perpendicular al segmento dado
pair Perpendicular(pair A, pair B)
    { return (A.y - B.y, B.x - A.x); }

// Prolongaciones de los lados
pen Punteado = linetype(new real[] {2,2});
pair C1=A + 0.8*(A-C);
pair B1=A + 0.8*(A-B);
draw(A -- C1, Punteado);
draw(A -- B1, Punteado);

// Las proyecciones
pair QBC=intersectionpoint(B -- C, A -- A-2*Perpendicular(B,C));
pair QAB=intersectionpoint(A -- B1, C -- C+2*Perpendicular(A,B1));
pair QAC=intersectionpoint(A -- C1, B -- B-2*Perpendicular(A,C1));

// Las alturas
draw(A -- QBC, 1bp+deepgreen);
draw(B -- QAC, 1bp+deepgreen);
draw(C -- QAB, 1bp+deepgreen);

// El ortocentro
pair H=extension(B, QAC, A, QBC);

// Prolongaciones de las alturas
draw(A -- H, Punteado+0.5bp);
draw(QAB -- H, Punteado+0.5bp);
draw(QAC -- H, Punteado+0.5bp);

// El ortocentro
dot(H, 4bp+deepgreen);

// El triangulo
draw(A -- B -- C -- cycle);
