//---------------------------------------------------------------
// Fichero:  pentagono.asy
// Objetivo: Representar un pengágono y su eje de simetría
// Fecha:    M.20.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Extremos de la recta
pair R1=(0,5.5), R2=(0,0);

// Los puntos
pair A=(0,5), B=(-2,3), C=(-2,1), D=(2,1), E1=(2,3);

// La recta
draw(R1 -- R2, 2bp+blue);
label("$r$", R2, NE);

// La figura
draw(A -- B -- C -- D -- E1 -- cycle);

// Marcamos todos los puntos
dot("A", A, NW, 4bp+black);
dot("B", B, W, 4bp+black);
dot("C", C, SW, 4bp+black);
dot("D", D, SE, 4bp+black);
dot("E", E1, E, 4bp+black);
