//---------------------------------------------------------------
// Fichero:  cuadrado2.asy
// Objetivo: Representar un cuadrado y un eje de simetría
// Fecha:    M.20.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Extremos de la recta
pair R1=(-1.2,0), R2=(1.2,0);

// Los puntos
pair A=(-1,1), B=(1,1), C=(1,-1), D=(-1,-1);

// La recta
draw(R1 -- R2, 2bp+blue);
label("$s$", (0,0), N);

// La figura
draw(A -- B -- C -- D -- cycle);

// Marcamos todos los puntos
dot("A", A, NW, 4bp+black);
dot("B", B, NE, 4bp+black);
dot("C", C, SE, 4bp+black);
dot("D", D, SW, 4bp+black);
