//---------------------------------------------------------------
// Fichero:  paso3.asy
// Objetivo: Representar el paso 3
// Fecha:    S.17.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// Extremos de las rectas
pair R1=(0,-1.5), R2=(0,2);
pair S1=(-2.5,0), S2=(2.5,0);

// Los dos puntos
pair P1=(-2,0), P2=(2,0);

// Las rectas
draw(R1 -- R2);
label("$r$", R2, SW);
draw(S1 -- S2);
label("$s$", (0.5,0), S);

// El punto
dot("P", P1, N, 4bp+black);

// El simétrico
dot("P'", P2, N, 4bp+black);

// Marcamos el ángulo recto
markrightangle(R2, (0,0), S1, 3mm, gray);
