//---------------------------------------------------------------
// Fichero:  regular-sol.asy
// Objetivo: Representar los ejes de un pentágono regular
// Fecha:    M.20.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definimos la figura
path Figura = polygon(5);

// Representamos la figura
draw(Figura);

// Calculamos uno de los ejes
path Eje = (0,-0.9) -- (0,1.1);

// Representamos los ejes
for ( int k=0 ; k<5 ; ++k)
    { draw(rotate(k*72)*Eje, 2bp+deepgreen); }
