//---------------------------------------------------------------
// Fichero:  cardioide-sol.asy
// Objetivo: Representar el eje de una cardioide
// Fecha:    M.20.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// polargraph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// La función en paramétricas
real f(real t)
    { return 1+cos(t); }

// Definimos la cardiode
path Cardioide = polargraph(f, 0, 2*pi, operator ..) -- cycle;

// La dibujamos
draw(rotate(90)*Cardioide);

// Calculamos el eje
path Eje = (0,-0.3) -- (0,2.2);

// Representamos el eje
draw(Eje, 2bp+deepgreen);
