//---------------------------------------------------------------
// Fichero:  enunciado.asy
// Objetivo: Mostrar el enunciado
// Fecha:    S.10.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los puntos
pair A=(1,13), B=(1,6), C=(6,12), D=(7,9), E1=(11,11);
pair F=(15,13), G=(16,10), H=(5,15), I=(8,6);

// Definición de los puntos para dibujar las rectas
pair R1=(4.82,15.53), R2=(8.16,5.52);
pair S1=(0,13.2), S2=(17,9.8);
pair T1=(0,5.5), T2=(17,14);

// Los puntos
dot(Label("A"), A, N, 5pt+black);
dot(Label("B"), B, N, 5pt+black);
dot(Label("C"), C, NE, 5pt+black);
dot(Label("D"), D, SE, 5pt+black);
dot(Label("E"), E1, N, 5pt+black);
dot(Label("F"), F, SE, 5pt+black);
dot(Label("G"), G, NE, 5pt+black);
dot(Label("H"), H, E, 5pt+black);
dot(Label("I"), I, NE, 5pt+black);

// Las rectas
draw(R1 -- R2);
draw(S1 -- S2);
draw(T1 -- T2);

// Los nombres de las rectas
label("$r$", (6,10.5));
label("$s$", (8.5,12));
label("$t$", (9.5,10));
