//---------------------------------------------------------------
// Fichero:  complejo.asy
// Objetivo: Representar un polígono complejo
// Fecha:    J.10.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(12,-1), C=(10,3), D=(8,1), E1=(2,2);

// El polígono
draw(A -- C -- B -- D -- E1 -- cycle);

// Los vértices
dot("E", A, SW, 3bp+black);
dot("F", B, E, 3bp+black);
dot("G", C, NE, 3bp+black);
dot("H", D, S, 3bp+black);
dot("I", E1, NW, 3bp+black);

// El punto de corte
pair T=intersectionpoint(A -- C, E1 -- D);
dot(T, 3bp+black);
draw(circle(T,0.5bp),red);
