//---------------------------------------------------------------
// Fichero:  prohibido.asy
// Objetivo: Representar una combinación prohibida
// Fecha:    S.26.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(Cos(144),Sin(144)), B=(0,0), C=(Cos(36),Sin(36)), D=A+(C-B);

// El punto auxiliar
pair Q=extension(B, B+(Cos(72),Sin(72)), A, C);

// Las diagonales
pen Punteado = linetype(new real[] {2,2});
draw(C -- Q, Punteado+gray);
draw(B -- D, Punteado+gray);

// El rombo
draw(A -- B -- C -- D -- cycle);

// Las líneas auxiliares
draw(D -- Q -- B);

