//---------------------------------------------------------------
// Fichero:  enunciado07.asy
// Objetivo: Enunciado 7
// Fecha:    L.21.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Las constantes
int NumPol=5, NumLad=3;

// El polígono regular principal
path Poligono=polygon(NumLad);

// El centro de giro
pair T=point(Poligono,0);

// El ángulo de giro
real Angulo=180*(NumLad-2)/NumLad;

// Los puntos extremos del ángulo
pair A, B;

// Los polígonos
for ( int i=0 ; i<NumPol ; ++i )
    {
    path Girado=rotate(i*Angulo,T)*Poligono;
    draw(Girado);
    if ( i == 0 )        { A=point(Girado,1); }
    if ( i == NumPol-1 ) { B=point(Girado,NumLad-1); }
    }

// La marca del ángulo
markangle("$\alpha$", radius=5mm, B, T, A, blue);
