//---------------------------------------------------------------
// Fichero:  enunciado3b.asy
// Objetivo: Enunciado 3b
// Fecha:    V.18.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3.4cm);

// Grosor de las líneas
defaultpen(1);

// Función que escribe la distancia entre dos puntos
void Dist(pair A, pair B, pair Pos)
    { label(string(round(length(A-B))), (A+B)/2, Pos, blue); }

// Función que marca un segmento entre dos puntos
void Segmento(pair A, pair B)
    {
    dot(A, 2bp+red);
    dot(B, 2bp+red);
    draw(A -- B, 0.75bp+red);
    }

// Los vértices exteriores
pair A1=(0,0), B1=(118,0), C1=(118,44), D1=(0,44);

// El polígono exterior
path Ext= A1-- B1 -- C1 -- D1 -- cycle;

// Los vértices interiores
pair A2=(9,8), B2=(109,8), C2=(64,36), D2=(54,36);

// El polígono interior
path Int= A2 -- B2 -- C2 -- D2 -- cycle;

// El conjunto de polígonos
path[] Conjunto={Ext,Int};

// El dibujo
filldraw(Conjunto,mediumgray+evenodd,black);

// Segmentos auxiliares
Segmento((A2.x,A1.y), A2);
Segmento((A1.x,A2.y), A2);
Segmento((B2.x,B1.y), B2);
Segmento((B1.x,B2.y), B2);
Segmento((C2.x,C1.y), C2);
Segmento((C1.x,C2.y), C2);
Segmento((D2.x,D1.y), D2);
Segmento((D1.x,D2.y), D2);

// Las medidas
Dist(A1,B1,S);
Dist(B1,C1,E);
Dist((A2.x,A1.y),A2, E);
Dist((A1.x,A2.y), A2, N);
Dist((B2.x,B1.y), B2, W);
Dist((B1.x,B2.y), B2, N);
Dist((C2.x,C1.y), C2, E);
Dist((C1.x,C2.y), C2, S);
Dist((D2.x,D1.y), D2, W);
Dist((D1.x,D2.y), D2, S);
