//---------------------------------------------------------------
// Fichero:  enunciado06.asy
// Objetivo: Enunciado 6
// Fecha:    X.16.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Los vértices
pair A=(0,0), B=(85,0), C=(85,85), D=(35,85), E1=(0,73);

// El polígono
draw(A -- B -- C -- D -- E1 -- cycle);

// Las medidas
label(Dist(A,B), (A+B)/2, S, blue);
label(Dist(B,C), (B+C)/2, E, blue);
label(Dist(D,E1), (D+E1)/2, N, blue);
label(Dist(E1,A), (E1+A)/2, W, blue);
